local assets =
{
	Asset("ANIM", "anim/mirrah_armor.zip"),
}

local function OnBlocked(owner) 
    owner.SoundEmitter:PlaySound("dontstarve/wilson/hit_armour")
end

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_body", "mirrah_armor", "mirrah_armor")
    inst:ListenForEvent("blocked", OnBlocked, owner)
end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
	inst:RemoveEventCallback("blocked", OnBlocked, owner)
end

local function fn()
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	--[[
	if IsDLCEnabled(CAPY_DLC) then
		MakeInventoryFloatable(inst, "idle_water", "idle")
    end
    ]]
    inst.AnimState:SetBank("mirrah_armor")
    inst.AnimState:SetBuild("mirrah_armor")
    inst.AnimState:PlayAnimation("anim")
    
    inst:AddTag("ruins")
	inst:AddTag("metal")
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/metalarmour"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/mirrah_armor.xml"
	
    inst:AddComponent("armor")
    inst.components.armor:InitCondition(TUNING.ARMORRUINS*.45, .50)

    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY
	
	local ARMORSLOW = 0.95

	inst.components.equippable.walkspeedmult = ARMORSLOW

    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    
    return inst
end




return Prefab( "common/inventory/mirrah_armor", fn, assets) 
